*****************************
*USER TO UPDATE FILE LOCATION
*****************************
local location `file'

import excel using "`location'\GDP.xlsx", clear 

rename A date 
rename B gdp

drop in 1/12

g m = substr(date,3,3)
g year = substr(date,6,4)

g month = 1 if m == "jan"
replace month = 2 if m == "feb"
replace month = 3 if m == "mar"
replace month = 4 if m == "apr"
replace month = 5 if m == "may"
replace month = 6 if m == "jun"
replace month = 7 if m == "jul"
replace month = 8 if m == "aug"
replace month = 9 if m == "sep"
replace month = 10 if m == "oct"
replace month = 11 if m == "nov"
replace month = 12 if m == "dec"

destring year gdp, replace 
g fyear = year 
replace fyear = year + 1 if month > 6 

g q = . 
replace q = 1 if month < 4 
replace q = 2 if month > 3 
replace q = 3 if month > 6 
replace q = 4 if month > 9 


preserve 
collapse(mean) gdp, by(q year)
gen qtr=yq(year,q)
format %tq qtr
keep gdp qtr 
save "`location'\gdp_quarterly.dta", replace
restore 

collapse(mean) gdp, by(fyear)
save "`location'\gdp.dta", replace



*NAB BUSINESS SURVEY 

import excel using "`location'\Business Surveys.xlsx", clear 

rename A date 
rename B busconditions
rename D busconfidence

drop in 1/12

g m = substr(date,3,3)
g year = substr(date,6,4)

g month = 1 if m == "jan"
replace month = 2 if m == "feb"
replace month = 3 if m == "mar"
replace month = 4 if m == "apr"
replace month = 5 if m == "may"
replace month = 6 if m == "jun"
replace month = 7 if m == "jul"
replace month = 8 if m == "aug"
replace month = 9 if m == "sep"
replace month = 10 if m == "oct"
replace month = 11 if m == "nov"
replace month = 12 if m == "dec"

destring year , replace 
destring bus* , replace 

g fyear = year 
replace fyear = year + 1 if month > 6 

g q = . 
replace q = 1 if month < 4 
replace q = 2 if month > 3 
replace q = 3 if month > 6 
replace q = 4 if month > 9 


preserve 
collapse(mean) bus*, by(q year)
gen qtr=yq(year,q)
format %tq qtr
keep bus* qtr 
save "`location'\surveys_quarterly.dta", replace
restore 

collapse(mean) bus*, by(fyear)
save "`location'\surveys.dta", replace



use "`location'\ms_sentiment_analysis.dta", clear 


egen firmid = group(asxcode)
tsset firmid fyear 

*Sentiment measured per 10000 words 
g sentiment = (positive-negative)/total
replace sentiment = sentiment*10000
g unshare = uncertain/total 
replace unshare = unshare*10000

g negshare = negativ/total
replace negshare = negshare*10000
g posshare = posit/total
replace posshare = posshare*10000

*IMPORTANT 
egen minyear = min(fyear)
g trend = fyear-minyear
reg sentiment trend
predict sentiment_res, res
replace sentiment_res = sentiment_res+_b[_cons]

reg unshare trend
predict unshare_res, res
replace unshare_res = unshare_res+_b[_cons]


xtreg negshare trend , fe
predict negshare_res ,res 
replace negshare_res = negshare_res +_b[_cons]
xtreg posshare trend , fe
predict posshare_res ,res 
replace posshare_res = posshare_res +_b[_cons]

su sentiment sentiment_res 

bysort fyear: egen ssales = sum(sales)
bysort fyear: egen sassets = sum(assets)
g wt = sales/ssales
g wsentiment = wt*sentiment_res 

xtile sentiment_nq = sentiment,nq(100)

merge m:1 fyear using "`location'\surveys.dta", nogen keep(match master)
merge m:1 fyear using "`location'\gdp.dta", nogen keep(match master)

g lgdp = log(gdp)
g lsales = log(sales)

tsset firmid fyear 
g dlgdp = d.lgdp 
g dlsales = d.lsale 

g gfc = (fyear ==2009)

reg sentiment_res busconditions 
reg sentiment_res busconf 
reghdfe sentiment_res busconditions dlgdp gfc, cluster(fyear firmid) noabsorb
reghdfe sentiment_res busconfidence dlgdp gfc, cluster(fyear firmid) noabsorb

reghdfe sentiment_res unshare dlsales qratio busconditions dlgdp gfc, cluster(fyear firmid) noabsorb


collapse(mean) sentiment sentiment_res qratio dlsales (sum) wsentiment, by(fyear)

merge 1:1 fyear using "`location'\surveys.dta", nogen keep(match master)
merge 1:1 fyear using "`location'\gdp.dta", nogen keep(match master)

g lgdp = log(gdp)

g id = 1 
tsset id fyear 

g dlgdp = d.lgdp

drop if fyear < 2003
drop if fyear > 2020 

g gfc = (fyear ==2009 | fyear ==2010)


reg sentiment_res busconditions , robust
reg sentiment_res busconditions dlgdp gfc, robust
reg sentiment_res busconditions dlsale gfc, robust
reg qratio busconditions dlgdp gfc, robust

twoway (line sentiment_res fyear) (line busconditions fyear)

twoway (scatter sentiment_res busconf) (lfit sentiment_res busconf)
twoway (scatter sentiment_res buscond) (lfit sentiment_res buscond)
graph export "`location'\Busconditions.jpg", as(jpg) name("Graph") quality(90) replace 


